﻿<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

session_start();
include 'conexao.php';

// Impede acesso direto via GET
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header("Location: login.php");
    exit;
}

// Sanitiza e valida entrada
$agente = trim($_POST['usuario'] ?? '');
$senha  = trim($_POST['senha'] ?? '');

if (empty($agente) || empty($senha)) {
    $_SESSION['erro_login'] = "Por favor, preencha todos os campos.";
    header("Location: login.php");
    exit;
}

if (!ctype_alnum($agente)) {
    $_SESSION['erro_login'] = "Usuário inválido.";
    header("Location: login.php");
    exit;
}

// Busca o usuário pelo número de agente
$sql = "SELECT * FROM usuarios WHERE agente = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $agente);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 1) {
    $usuario = $result->fetch_assoc();

    // Verifica a senha com password_verify
    if (password_verify($senha, $usuario['senha'])) {
        // Salva os dados principais do usuário na sessão
        $_SESSION['usuario'] = [
            'id'     => $usuario['id'],
            'nome'   => $usuario['nome'] ?? 'Usuário',
            'perfil' => $usuario['perfil'] ?? '',
            'agente' => $usuario['agente'],
            'foto'   => $usuario['foto'] ?? 'sem-foto.png'
        ];

        // 🔒 Redirecionamento ajustado com strcasecmp() para ser mais robusto.
        if (strcasecmp($_SESSION['usuario']['perfil'], 'ADMINISTRADOR') === 0) {
            header("Location: painel.php");
        } elseif (strcasecmp($_SESSION['usuario']['perfil'], 'PROFESSOR') === 0) {
            header("Location: painel_professor.php");
        } elseif (strcasecmp($_SESSION['usuario']['perfil'], 'SUDIRECÇÃO ADMINISTRATIVA') === 0) {
            header("Location: painel_subadmin.php");
        } elseif (strcasecmp($_SESSION['usuario']['perfil'], 'SUBDIRECÇÃO PEDAGÓGICA') === 0) {
            header("Location: painel_subpedagogico.php");
        } elseif (strcasecmp($_SESSION['usuario']['perfil'], 'SECRETARIA GERAL') === 0) {
            header("Location: painel_secretaria_geral.php");
        } elseif (strcasecmp($_SESSION['usuario']['perfil'], 'SECRETARIA PEDAGÓGICA') === 0) {
            header("Location: painel_secpedagogica.php");
        } elseif (strcasecmp($_SESSION['usuario']['perfil'], 'Coordenação de Curso') === 0) {
            header("Location: painel_coordcurso.php");
        } else {
            $_SESSION['erro_login'] = "Perfil desconhecido.";
            header("Location: login.php");
        }

        exit;
    } else {
        $_SESSION['erro_login'] = "Senha incorreta.";
        header("Location: login.php");
        exit;
    }
} else {
    $_SESSION['erro_login'] = "Usuário não encontrado.";
    header("Location: login.php");
    exit;
}
?>